using UnityEngine;
using TMPro;
using UnityStandardAssets.Vehicles.Car;

public class TestStats : MonoBehaviour
{
    [Header("UI References Go Here")]
    public TextMeshProUGUI finalTopSpeedValue;  // reference top speed value textbox
    public TextMeshProUGUI bestLapTimeValue;    // reference best lap time value textbox
    public TextMeshProUGUI driveTypeValue;      // reference drive type value textbox
    public TextMeshProUGUI steerAngleValue;     // reference steering angle value textbox
    public TextMeshProUGUI topSpeedLimitValue;  // reference speed limiter value textbox
    public TextMeshProUGUI downforceValue;      // reference downforce value textbox
    public TextMeshProUGUI tractionValue;       // reference traction control value textbox
    public CarController controller;            // reference CarController script
    float topSpeedValue = 0;
    private float currentSpeed = 0f;
    public LapTimeUI LapTimeUI;                 // reference LapTime UI


    // when test is finished display UI with test results
    public void DispayStats()
    {
        float fastestLapTime = LapTimeUI.GetFastestLapFromUI();
        finalTopSpeedValue.text = topSpeedValue.ToString("F2") + " mph";
        bestLapTimeValue.text = fastestLapTime.ToString();
        steerAngleValue.text = controller.m_MaximumSteerAngle.ToString() + "\x00b0";
        topSpeedLimitValue.text = controller.m_Topspeed.ToString() + " mph";
        downforceValue.text = controller.m_Downforce.ToString();

        switch(controller.m_CarDriveType)
        {
            case CarDriveType.FrontWheelDrive:
                driveTypeValue.text = "FWD";
                break;
            case CarDriveType.RearWheelDrive:
                driveTypeValue.text = "RWD";
                break;
            case CarDriveType.FourWheelDrive:
                driveTypeValue.text = "4X4";
                break;        
        }

        if (controller.tractionToggle.isOn)
        {
            tractionValue.text = "ON";
        }
        else
        {
            tractionValue.text = "OFF";
        }

        GameObject.Find("Car Vitals UI").SetActive(false); // turn off car vitals to increase readability
    }

    private void Update()
    {
        // calculate current speed
        currentSpeed = controller.mphSpeed;

        // update top speed if the current speed exceeds it
        if (currentSpeed > topSpeedValue)
        {
            topSpeedValue = currentSpeed;
        }
    }
}
