﻿// This script keeps a record of the laptimes and displays them to the User Interface.

using UnityEngine;
using TMPro;

public class LapTimeUI : MonoBehaviour
{
    public TextMeshProUGUI[] lapTimeLabels;     // array for laptime text boxes 
    public TextMeshProUGUI finalTimeLabel;      // total time for 3 laps

    public float fastestLapTime { get; private set; } = float.MaxValue;

    // make textboxes empty on Awake
    void Awake()
    {
        for (int i = 0; i < lapTimeLabels.Length; i++)
        {
            lapTimeLabels[i].text = "";
        }
            
        finalTimeLabel.text = "";
    }

    // display laptime for identified lap
    public void SetLapTime(int lapNumber, float lapTime)
    {
        if (lapNumber >= lapTimeLabels.Length)
            return;

        lapTimeLabels[lapNumber].text = ConvertTimeToString(lapTime);

        if (lapTime < fastestLapTime)
            fastestLapTime = lapTime;
    }

    // display total time for all laps
    public void SetFinalTime(float lapTime)
    {
        finalTimeLabel.text = ConvertTimeToString(lapTime);
    }

    // convert numbers to text and maintain a readabe formatting
    string ConvertTimeToString(float time)
    {
        int minutes = (int)(time / 60);
        float seconds = time % 60f;
        string output = minutes.ToString("00") + ":" + seconds.ToString("00.000");
        return output;
    }

    // identify the time of the fastest lap to be displayed on the test results UI
    public float GetFastestLapFromUI()
    {
        float fastestLap = float.MaxValue;

        foreach (TextMeshProUGUI lapTimeLabel in lapTimeLabels)
        {
            string[] timeParts = lapTimeLabel.text.Split(':');
            int minutes = int.Parse(timeParts[0]);
            float seconds = float.Parse(timeParts[1]);
            float totalTime = (minutes * 60) + seconds;

            if (totalTime < fastestLap)
            {
                fastestLap = totalTime;
            }
        }

        return fastestLap;
    }

}
