﻿// This script ensures that the tester cannot cheat by "activating" the FinishLine script once the car comes close to completing a full lap

using UnityEngine;

public class LapChecker : MonoBehaviour
{
	public FinishLine finishLine;   // reference to the FinishLine script
    private bool hasStartedLap = false;


    void OnTriggerEnter(Collider other)
    {
        // if the object passing through this collider is tagged as "PlayerSensor"...
        if (other.gameObject.CompareTag("PlayerSensor"))
        {
            //...set the isReady variable of the FinishLine script
            finishLine.isReady = true;
        }
    }

}
