﻿// This script handles letting the gamemanager know when the car completes a lap. It works together with the LapChecker script to ensure that the car can't cheat

using UnityEngine;

public class FinishLine : MonoBehaviour
{
	[HideInInspector]	public bool isReady;	// is the car ready to complete a lap? 

	public bool debugMode;                      // debug variable that enables quick testing of laps

    private bool hasStartedLap = false;

    // called when the car drives through the finish line
    void OnTriggerEnter(Collider other)
    {
        // if the player has passed through the LapChecker (isReady) OR if Debug Mode is enabled (debugMode)
        // AND the object passing through this trigger is tagged as "PlayerSensor"...
        if ((isReady || debugMode) && other.gameObject.CompareTag("PlayerSensor"))
        {
            //...let the Game Manager know that the player completed a lap...
            GameManager.instance.PlayerCompletedLap();
            //...and deactivate the finish line until the player completes another lap
            isReady = false;
        }
    }
}
