﻿// This script handles updating the UI that shows the car's speed and laps. It is controlled by the GameManager

using UnityEngine;
using TMPro;
using UnityStandardAssets.Vehicles.Car;

public class CarUI : MonoBehaviour
{
	[Header("UI Text References")]
	public TextMeshProUGUI currentSpeedValue;			// the text element for the current speed
	public TextMeshProUGUI steeringAngleValue;			// the text element for the current lap
	public TextMeshProUGUI currentDirectionText;		// reference to the direction description textbox
	public CarController controller;
    
	[Header("Direction Colors")]
    public Color turningLeftColor = Color.yellow;
    public Color turningRightColor = Color.red;

    private void Start()
    {
		currentSpeedValue.text = "0";
        steeringAngleValue.text = "0" + "\x00b0"; // degree symbol
		currentDirectionText.text = " ";
    }

    public void SetLapDisplay(int currentLap, int numberOfLaps)
	{
		// if we are trying to set a lap greater than the total number of laps, exit
		if (currentLap > numberOfLaps)
			return;

		// update the current lap text
		steeringAngleValue.text = currentLap + "/" + numberOfLaps;
	}

	public void SetSpeedDisplay(float currentSpeed)
	{
		// turn the current speed into an integer and set it in the UI
		controller.mphSpeed = currentSpeed;
		currentSpeedValue.text = currentSpeed.ToString("F0");
	}

    public void SetCarSteerAngle()
    {
		// display the current steer direction in degrees to 2 decimal points
		steeringAngleValue.text = controller.m_SteerAngle.ToString("F2") + "\x00b0";

		if(controller.m_SteerAngle < 0)
		{
			currentDirectionText.text = "Turning Left";
			currentDirectionText.color = turningLeftColor;
		}
		else
		{
            currentDirectionText.text = "Turning Right";
			currentDirectionText.color = turningRightColor;
        }
    }
}